% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dBUMfit}
\alias{dBUMfit}
\title{Function to fit a p-value distribution under beta-uniform mixture model}
\usage{
dBUMfit(x, ntry = 1, hist.bum = T, contour.bum = T, verbose = T)
}
\arguments{
\item{x}{a vector containing input p-values}

\item{ntry}{an integeter specifying how many trys are used to find the
optimised parameters by maximum likelihood estimation}

\item{hist.bum}{logical to indicate whether the histogram graph should
be drawn}

\item{contour.bum}{logical to indicate whether a contour plot should be
drawn to show the log likelihood as a function of two parameters (a and
lambda) in the beta-uniform mixture model}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "BUM", a list with following elements:
\itemize{
\item{\code{lambda}: estimated mixture parameter}
\item{\code{a}: estimated shape parameter}
\item{\code{NLL}: Negative log-likelihood}
\item{\code{pvalues}: the input pvalues}
\item{\code{call}: the call that produced this result}
}
}
\description{
\code{dBUMfit} is supposed to take as input a vector of p-values for
deriving their distribution under beta-uniform mixture model (see Note
below). The density distribution of input p-values is expressed as a
mixture of two components: one for the null hypothesis (the noise
component) and the other for the alternative hypothesis (the signal
component). The noise component is the uniform density, while the
signal component is the remainder of the mixture distribution. It
returns an object of class "BUM".
}
\note{
The probability density function of p-values under the Beta-Uniform
Mixture model is formulated as: \eqn{f(x|\lambda,a) = \lambda +
(1-\lambda)*a*x^{a-1}}. The model names after mixing two distributions:
\itemize{
\item{the uniform distribution with the density function as
\eqn{\frac{1}{b-a}|_{a=0}^{b=1}=1}}
\item{the beta distribution with the density function as
\eqn{\frac{\Gamma(a+b)}{\Gamma(a)+\Gamma(b)}*x^{a-1}*(1-x)^{b-1}|_{b=1}=a*x^{a-1}}}
}
Both are mixed via \eqn{\lambda}. The mixture parameter \eqn{\lambda}
measures the contribution from the uniform distribution. Accordingly,
\eqn{1-\lambda} measures the contribution from the beta distribution.
Notably, the probability density function of the beta distribution can
be splitted into two parts (rather than the exclusitive signal):
\itemize{
\item{the constant part as noise: \eqn{a*x^{a-1}|_{x=1}=a}}
\item{the rest part as signal: \eqn{a*(x^{a-1}-1)}}
}
In other words, there is no signal at \eqn{x=1} but all being noise. It
is a conservative, upper bound estimation of the noise. Therefore, the
probability density function in the model can be decomposed into
signal-noise components:
\itemize{
\item{the signal component: \eqn{(1-\lambda)*a*(x^{a-1}-1)}}
\item{the noise component: \eqn{\lambda + (1-\lambda)*a}}
}
It is misleading to simply view \eqn{\lambda} as the noise component
and \eqn{(1-\lambda)*a*x^{a-1}} as the signal component, just as
wrongly do in the literatures (e.g.
\url{http://www.ncbi.nlm.nih.gov/pubmed/18586718})
}
\examples{
# 1) generate an vector consisting of random values from beta distribution
x <- rbeta(1000, shape1=0.5, shape2=1)

# 2) fit a p-value distribution under beta-uniform mixture model
fit <- dBUMfit(x)
fit$lambda
fit$a
}
\seealso{
\code{\link{dBUMscore}}
}

