test_that("output", {
  expect_snapshot(error = TRUE, {
    abort_key_set_force_false("pk_table")
    abort_not_unique_key("Christmas", "Rudolph")
    abort_not_unique_key("Christmas", c("elves", "Rudolph", "mulled_wine"))
    abort_table_not_in_dm("laziness", "hard_work")
    abort_not_subset_of("playing", "game", "hunting", "game")
    abort_sets_not_equal(c("A problem occurred.", "And another, even worse problem, occurred shortly after."))
    # The mentioned reasons for not being bijective and injective are the same, but this is intended:
    # If surjectivity is not given during the test for bijectivity it will fail earlier
    abort_not_bijective("child_table_name", "fk_col_name")
    abort_not_injective("child_table_name", "fk_col_name")
    abort_ref_tbl_has_no_pk("parent_table")
    abort_is_not_fkc()
    abort_rm_fk_col_missing()
    abort_last_col_missing()
    abort_no_cycles(create_graph_from_dm(dm_for_filter_w_cycle()))
    abort_tables_not_reachable_from_start()
    abort_wrong_col_names("table_name", c("col_1", "col_2"), c("col_one", "col_2"))
    abort_wrong_col_names("table_name", c("col_1", "col_2"), "col_one")
    abort_dupl_new_id_col_name("tibbletable")
    abort_no_overwrite()
    abort_no_types()
    abort_no_indexes()
    abort_no_unique_indexes()
    abort_key_constraints_need_db()
    abort_pk_not_defined()
    abort_fk_exists("child", c("child_1", "child_2"), "parent")
    abort_first_rm_fks("parent", c("child_1", "child_2"))
    abort_no_src_or_con()
    abort_update_not_supported()
    abort_only_possible_wo_filters("find_wisdom")
    abort_tables_not_neighbors("subjects", "king")
    abort_only_parents()
    abort_not_same_src()
    abort_what_a_weird_object("monster")
    abort_not_same_src()
    abort_squash_limited()
    abort_apply_filters_first("join_tightly")
    abort_no_flatten_with_nest_join()
    abort_is_not_dm("blob")
    abort_con_only_for_dbi()
    abort_only_possible_wo_zoom("dm_zoom_to")
    abort_only_possible_w_zoom("dm_update_zoomed")
    abort_learn_keys("some reason")
    abort_tbl_access("accessdenied")
    abort_unnamed_table_list()
    abort_need_unique_names("clone")
    abort_fk_not_tracked("hook", "eye")
    abort_dm_invalid("it's ugly.")
    abort_no_table_provided()
    abort_table_not_zoomed("blur", c("focus_1", "focus_2"))
    abort_not_pulling_multiple_zoomed()
    abort_cols_not_avail(c("pink5", "elephant"))
    abort_only_named_args("give_names", "frobnicability")
    abort_wrong_syntax_set_cols()
    abort_temp_table_requested(c("i_am_temporary", "i_am_permanent"), "i_am_permanent")
    abort_pk_not_tracked("house", "house_number")
    abort_only_for_local_src(mtcars)
    abort_parameter_not_correct_class("number", correct_class = "numeric", class = "logical")
    abort_parameter_not_correct_length("length_1_parameter", 1, letters[1:26])
    warn_if_arg_not("NULL", c("MSSQL", "Postgres"), arg_name = "dbms_dependent_arg")
    abort_no_schemas_supported("FantasticDatabaseManagementSystem", "hyperconnection")
    abort_no_schemas_supported(con = 1)
    abort_no_schemas_supported()
    abort_temporary_not_in_schema()
    abort_one_of_schema_table_names()
  })
})
