% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{sql_schema_exists}
\alias{sql_schema_exists}
\title{Check for existence of a schema on a database}
\usage{
sql_schema_exists(dest, schema, ...)
}
\arguments{
\item{dest}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{schema}{Class \code{character} or \code{SQL}, name of the schema}

\item{...}{Passed on to the individual methods.}
}
\value{
A boolean: \code{TRUE} if schema exists, \code{FALSE} otherwise.
}
\description{
\code{sql_schema_exists()} checks, if a schema exists on the database.
}
\details{
Methods are not available for all DBMS.

Additional arguments are:
\itemize{
\item \code{dbname}: supported for MSSQL. Check if a schema exists on a different
database on the connected MSSQL-server; default: database addressed by \code{dest}.
}
}
\seealso{
Other schema handling functions: 
\code{\link{sql_schema_create}()},
\code{\link{sql_schema_drop}()},
\code{\link{sql_schema_list}()}
}
\concept{schema handling functions}
