% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{dm_is_referenced}
\alias{dm_is_referenced}
\title{Check foreign key reference}
\usage{
dm_is_referenced(dm, table)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.}
}
\value{
\code{TRUE} if at least one foreign key exists that points to the primary
key of the \code{table} argument, \code{FALSE} otherwise.
}
\description{
Is a table of a \code{\link{dm}} referenced by another table?
}
\examples{
dm_nycflights13() \%>\%
  dm_is_referenced(airports)
dm_nycflights13() \%>\%
  dm_is_referenced(flights)
}
\seealso{
Other functions utilizing foreign key relations: 
\code{\link{dm_get_referencing_tables}()}
}
\concept{functions utilizing foreign key relations}
