% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-interface.R
\name{copy_dm_to}
\alias{copy_dm_to}
\title{Copy data model to data source}
\usage{
copy_dm_to(
  dest,
  dm,
  ...,
  types = NULL,
  overwrite = NULL,
  indexes = NULL,
  unique_indexes = NULL,
  set_key_constraints = TRUE,
  unique_table_names = FALSE,
  table_names = NULL,
  temporary = TRUE
)
}
\arguments{
\item{dest}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{dm}{A \code{dm} object.}

\item{...}{Possible further arguments passed to \code{\link[dplyr:copy_to]{dplyr::copy_to()}}, which is used on each table.}

\item{overwrite, types, indexes, unique_indexes}{Must remain \code{NULL}.}

\item{set_key_constraints}{Boolean variable, if \code{TRUE} will mirror \code{dm} key constraints on a database.}

\item{unique_table_names}{Boolean, if \code{FALSE} (default), the original table names will be used, if \code{TRUE},
unique table names will be created based on the original table names.}

\item{table_names}{A named character vector, containing the names that you want the tables in the \code{dm} to have
after copying them to the database.
The table names within the \code{dm} will remain unchanged.
The name of each element of the vector needs to be one of the table names of the \code{dm}.
Those tables of the \code{dm} that are not addressed will be called by their original name on the database.}

\item{temporary}{Boolean variable, if \code{TRUE}, only temporary tables will be created.
These tables will vanish when disconnecting from the database.}
}
\value{
A \code{dm} object on the given \code{src}.
}
\description{
\code{copy_dm_to()} takes a \link[dplyr:src_dbi]{dplyr::src_dbi} object or a \code{\link[DBI:DBIConnection-class]{DBI::DBIConnection}} object as its first argument
and a \code{\link{dm}} object as its second argument.
The latter is copied to the former.
By default, temporary tables will be created and the key constraints will be set
(currently only on MSSQL and Postgres databases).
}
\details{
No tables will be overwritten; passing \code{overwrite = TRUE} to the function will give an error.
Types are determined separately for each table, setting the \code{types} argument will
also throw an error.
The arguments are included in the signature to avoid passing them via the
\code{...} ellipsis.
}
\examples{
src_sqlite <- dplyr::src_sqlite(":memory:", create = TRUE)
iris_dm <- copy_dm_to(
  src_sqlite,
  as_dm(list(iris = iris)),
  set_key_constraints = FALSE
)
}
\concept{DB interaction functions}
