% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{summary.compare_category}
\alias{summary.compare_category}
\alias{print.compare_category}
\title{Summarizing compare_category information}
\usage{
\method{summary}{compare_category}(
  object,
  method = c("all", "table", "relative", "chisq"),
  pos = NULL,
  na.rm = TRUE,
  marginal = FALSE,
  verbose = TRUE,
  ...
)

\method{print}{compare_category}(x, ...)
}
\arguments{
\item{object}{an object of class "compare_category", usually, a result of a call to compare_category().}

\item{method}{character. Specifies the type of information to be aggregated. "table" create contingency table, 
"relative" create relative contingency table, and "chisq" create information of chi-square test. 
and "all" aggregates all information. The default is "all"}

\item{pos}{integer. Specifies the pair of variables to be summarized by index. 
The default is NULL, which aggregates all variable pairs.}

\item{na.rm}{logical. Specifies whether to include NA when counting the contingency tables or performing a chi-square test. 
The default is TRUE, where NA is removed and aggregated.}

\item{marginal}{logical. Specifies whether to add marginal values to the contingency table.
The default value is FALSE, so no marginal value is added.}

\item{verbose}{logical. Specifies whether to output additional information during the calculation process.
The default is to output information as TRUE. In this case, the function returns the value with invisible(). 
If FALSE, the value is returned by return().}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "compare_category", usually, a result of a call to compare_category().}
}
\description{
print and summary method for "compare_category" class.
}
\details{
print.compare_category() displays only the information compared between the variables included in compare_category. 
The "type", "variables" and "combination" attributes are not displayed.
When using summary.compare_category(), it is advantageous to set the verbose argument to TRUE if the user is only viewing information from the console. 
It is also advantageous to specify FALSE if you want to manipulate the results.
}
\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

library(dplyr)

# Compare the all categorical variables
all_var <- compare_category(heartfailure2)

# Print compare_category class objects
all_var

# Compare the two categorical variables
two_var <- compare_category(heartfailure2, smoking, death_event)

# Print compare_category class objects
two_var

# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Summary by returned objects
stat

# component of table 
stat$table

# component of chi-square test 
stat$chisq

# component of chi-square test 
summary(all_var, "chisq")

# component of chi-square test (first, third case)
summary(all_var, "chisq", pos = c(1, 3))

# component of relative frequency table 
summary(all_var, "relative")

# component of table without missing values 
summary(all_var, "table", na.rm = TRUE)

# component of table include marginal value 
margin <- summary(all_var, "table", marginal = TRUE)
margin

# component of chi-square test 
summary(two_var, method = "chisq")

# verbose is FALSE 
summary(all_var, "chisq", verbose = FALSE)

#' # Using pipes & dplyr -------------------------
# If you want to use dplyr, set verbose to FALSE
summary(all_var, "chisq", verbose = FALSE) \%>\% 
  filter(p.value < 0.26)

# Extract component from list by index
summary(all_var, "table", na.rm = TRUE, verbose = FALSE) \%>\% 
  "[["(1)

# Extract component from list by name
summary(all_var, "table", na.rm = TRUE, verbose = FALSE) \%>\% 
  "[["("smoking vs death_event")
}
   
}
\seealso{
\code{\link{plot.compare_category}}.
}
