`lines.crossreduce` <-
function(x, ci="n", ci.arg, ci.level=x$ci.level, exp=NULL, ...) {

###########################################################################
# CHECKS

if(class(x)!="crossreduce") stop("'x' must be of class 'crossreduce'")
if(!ci%in%c("area","bars","lines","n")) {
  stop("'ci' must be one of 'area', 'bars', 'lines' or 'n'")
}
if(missing(ci.arg)) {
  ci.arg <- list()
} else if(!is.list(ci.arg)) stop("'ci.arg' must be a list")
if(!is.numeric(ci.level)||ci.level>=1||ci.level<=0) {
  stop("'ci.level' must be numeric and between 0 and 1")
}
if(!is.null(exp)&&!is.logical(exp)) stop("'exp' must be logical")

##########################################################################
# COMPUTE OUTCOMES

# SET THE Z LEVEL EQUAL TO THAT STORED IN OBJECT IF NOT PROVIDED
z <- qnorm(1-(1-ci.level)/2)
x$high <- x$fit+z*x$se
x$low <- x$fit-z*x$se
noeff <- 0

# EXPONENTIAL
if((is.null(exp)&&x$model.link%in%c("log","logit"))||
  (!is.null(exp)&&exp==TRUE)) {
  x$fit <- exp(x$fit)
  x$high <- exp(x$high)
  x$low <- exp(x$low)
  noeff <- 1
}

##########################################################################
# GRAPH

if(x$type=="var") {
  xvar <- .seq(x$lag,x$bylag)
} else {
  xvar <- x$predvar
}

# SET DEFAULT VALUES IF NOT INCLUDED BY THE USER
plot.arg <- list(type="l",col=2)
plot.arg <- modifyList(plot.arg,list(...))
  
# SET CONFIDENCE INTERVALS
.fci(ci=ci,x=xvar,high=x$high,low=x$low,ci.arg,plot.arg)
plot.arg <- modifyList(plot.arg,c(list(x=xvar,y=x$fit)))

# PLOT
do.call("lines",plot.arg)

}

#
