% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_coerce_time_class.R
\name{utils_coerce_time_class}
\alias{utils_coerce_time_class}
\title{Coerces Vector to a Given Time Class}
\usage{
utils_coerce_time_class(x = NULL, to = "POSIXct")
}
\arguments{
\item{x}{(required, vector of class Date or POSIXct) time vector to convert. Default: NULL}

\item{to}{(required, class name) class to coerce \code{x} to. Either "Date", "POSIXct", "integer" or "numeric". Default: "POSIXct"}
}
\value{
time vector
}
\description{
Coerces Vector to a Given Time Class
}
\examples{
x <- utils_coerce_time_class(
  x = c("2024-01-01", "2024-02-01"),
  to = "Date"
)

x
class(x)

x <- utils_coerce_time_class(
  x = c("2024-01-01", "2024-02-01"),
  to = "POSIXct"
)

x
class(x)

x <- utils_coerce_time_class(
  x = c("2024-01-01", "2024-02-01"),
  to = "numeric"
)

x
class(x)
}
\seealso{
Other internal_time_handling: 
\code{\link{utils_as_time}()},
\code{\link{utils_is_time}()},
\code{\link{utils_new_time}()},
\code{\link{utils_time_keywords}()},
\code{\link{utils_time_keywords_dictionary}()},
\code{\link{utils_time_keywords_translate}()},
\code{\link{utils_time_units}()}
}
\concept{internal_time_handling}
