% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{subset_matrix_by_rows_cpp}
\alias{subset_matrix_by_rows_cpp}
\title{(C++) Subset Matrix by Rows}
\usage{
subset_matrix_by_rows_cpp(m, rows)
}
\arguments{
\item{m}{(required, numeric matrix) a univariate or multivariate time series.}

\item{rows}{(required, integer vector) vector of rows to subset from a
least-cost path data frame.}
}
\value{
numeric matrix
}
\description{
Subsets a time series matrix to the coordinates of a trimmed
least-cost path when blocks are ignored during a dissimilarity analysis.
}
\examples{
#simulate a time series
m <- zoo_simulate(seed = 1)

#sample some rows
rows <- sample(
  x = nrow(m),
  size = 10
  ) |>
  sort()

#subset by rows
m_subset <- subset_matrix_by_rows_cpp(
  m = m,
  rows = rows
  )

#compare with original
m[rows, ]

}
\seealso{
Other Rcpp_auto_sum: 
\code{\link{auto_distance_cpp}()},
\code{\link{auto_sum_cpp}()},
\code{\link{auto_sum_full_cpp}()},
\code{\link{auto_sum_path_cpp}()}
}
\concept{Rcpp_auto_sum}
