% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cities_temperature}
\alias{cities_temperature}
\title{Long Term Monthly Temperature in 20 Major Cities}
\format{
data frame with 3 columns and 52100 rows.
}
\usage{
data(cities_temperature)
}
\description{
Average temperatures between 1975 and 2010 of 20 major cities of the world. \href{https://www.kaggle.com/datasets/berkeleyearth/climate-change-earth-surface-temperature-data?resource=download&select=GlobalLandTemperaturesByMajorCity.csv}{Source}.

Site coordinates for this dataset are in \link{cities_coordinates}.

The full dataset with 100 cities can be downloaded from \url{https://github.com/BlasBenito/distantia/blob/main/data_full/cities_temperature.rda} (use the "Download raw file" button).
}
\examples{
data("cities_temperature")

#to time series list
cities <- tsl_initialize(
  x = cities_temperature,
  name_column = "name",
  time_column = "time"
)

#time series plot
if(interactive()){

 #only four cities are shown
 tsl_plot(
  tsl = tsl_subset(
    tsl = tsl,
    names = 1:4
    ),
  guide = FALSE
  )

}
}
\seealso{
Other example_data: 
\code{\link{albatross}},
\code{\link{cities_coordinates}},
\code{\link{covid_counties}},
\code{\link{covid_prevalence}},
\code{\link{eemian_coordinates}},
\code{\link{eemian_pollen}},
\code{\link{fagus_coordinates}},
\code{\link{fagus_dynamics}},
\code{\link{honeycomb_climate}},
\code{\link{honeycomb_polygons}}
}
\concept{example_data}
\keyword{datasets}
