% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNA.R
\name{handleNA}
\alias{handleNA}
\title{Handles emtpy and NA data in a multivariate time series.}
\usage{
handleNA(
  sequence = NULL,
  if.empty.cases = "zero"
  )
}
\arguments{
\item{sequence}{Dataframe, a multivariate time-series.}

\item{if.empty.cases}{character, one of: "omit" (default), "zero". When "omit", the function removes every row with at least one empty/NA record. When "zero", empty/NA data is replaced with zeros.}
}
\value{
A dataframe with the same columns as \code{sequence}.
}
\description{
This function is used internally by \code{\link{prepareSequences}}. Handles empty and NA data in a multivariate time-series in two possible ways: 1) deleting rows with NA or empty cases; 2) replacing NA data with zeros.
}
\examples{
data(sequenceB)
B.sequence <- handleNA(
  sequence = sequenceB,
  if.empty.cases = "zero"
  )

}
\author{
Blas Benito <blasbenito@gmail.com>
}
