% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{unite_two_DF}
\alias{unite_two_DF}
\title{Combine two data frames}
\usage{
unite_two_DF(
  data1,
  data1.shared.var,
  data1.shared.column.num = 1,
  data2,
  data2.shared.var,
  data2.shared.column.num = 1,
  delete.not.shared = FALSE,
  not.shared = "all",
  verbose = TRUE
)
}
\arguments{
\item{data1, data2}{data frames}

\item{data1.shared.var, data2.shared.var}{same variables in data frames}

\item{data1.shared.column.num, data2.shared.column.num}{integer; column numbers of same variables in data frames}

\item{delete.not.shared}{logical; delete rows that present in one data frame but do not present in other data frame}

\item{not.shared}{character; which rows to delete; possible values are
\code{"data1"} (delete rows that present in \code{data1} but do not present in \code{data2}),
\code{"data2"} (delete rows that present in \code{data2} but do not present in \code{data1}),
\code{"all"} (both variants)}

\item{verbose}{logical; show messages}
}
\value{
Combined data frame.
}
\description{
Combine two data frames according to shared variable
}
\details{
This function combines columns of two data frames according to \code{shared.var} which acts like rows' identification number.
If \code{shared.var} value from one data frame do not present in other data frame, NAs are produced.
Those absent rows are deleted when \code{delete.not.shared = TRUE}.

\code{data1.shared.var} and {data2.shared.var} must contain unique values within its own data frame.

Order of rows in resulting data frame is according to \code{data1}.
\code{data2.shared.var} is removed from resulting data frame.
}
\examples{
#same values in shared variables
data1 <- data.frame (N = 1:5, letter = rep("A", 5))
data2 <- data.frame (N = 1:5, letter = rep("B", 5), cs = rep("cs",5))
unite_two_DF (data1 = data1, data1.shared.var = data1$N, data2 = data2, data2.shared.var = data2$N,
            delete.not.shared = TRUE, not.shared = "all")
#different values in shared variables
data1 <- data.frame (N = 1:5, letter = rep("A", 5))
data2 <- data.frame (N = 3:8, letter = rep("B", 6), cs = rep("cs",6))
unite_two_DF (data1 = data1, data1.shared.var = data1$N, data2 = data2, data2.shared.var = data2$N)
unite_two_DF (data1 = data1, data1.shared.var = data1$N, data2 = data2, data2.shared.var = data2$N,
            delete.not.shared = TRUE, not.shared = "data1")
unite_two_DF (data1 = data1, data1.shared.var = data1$N, data2 = data2, data2.shared.var = data2$N,
            delete.not.shared = TRUE, not.shared = "data2")
unite_two_DF (data1 = data1, data1.shared.var = data1$N, data2 = data2, data2.shared.var = data2$N,
            delete.not.shared = TRUE, not.shared = "all")

}
\author{
Elena N. Filatova
}
