% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads.R
\name{unite_NCBI_ac.nums}
\alias{unite_NCBI_ac.nums}
\title{Assigns master record's id to all project records}
\usage{
unite_NCBI_ac.nums(
  data,
  ac.num.var,
  title.var,
  db.var,
  type = "shotgun",
  order = TRUE,
  new.titles = FALSE
)
}
\arguments{
\item{data}{data frame; contains information about sequence records.}

\item{ac.num.var}{character; data frame variable that contains sequence accession numbers.}

\item{title.var}{character; data frame variable that contains sequence titles.}

\item{db.var}{character; data frame variable that contains source data base names.}

\item{type}{character; type of the project which records should be united with one accession number.
At the moment \code{"shotgun"} is the only possible value which corresponds to the whole genome shotgun sequencing project with shotgun technology.}

\item{order}{logical; rearrange a data frame in alphabetical order of accession numbers (highly recommended).}

\item{new.titles}{logical; add new titles according to new access numbers.}
}
\value{
If \code{new.titles = FALSE} data frame with old and new access numbers is returned.

If \code{new.titles = TRUE} data frame with old and new access numbers and new titles is returned.
}
\description{
The function assigns the project master record's NCBI access number to all records that belong to the project.
}
\details{
The function looks through all records in a data frame.
If the record belongs to the project (for example, WGS-project), the function assigns the project master record's NCBI access number to this record.
If the record is not related to any project, it retains its own accession number.

It is highly recommended to arrange the data in alphabetical order of accession numbers,
 since the first record among similar ones is determined as master record.
}
\examples{
# Example with sequences from WGS-project of Chlamydia pneumoniae genome
data (meta.target) #load metadata of target sequences with GenBank identificators
meta.target.new.ids <- unite_NCBI_ac.nums (data = meta.target,
                                          ac.num.var = meta.target$GB_AcNum,
                                          title.var = meta.target$title,
                                          db.var = meta.target$source_db,
                                          type = "shotgun", order = TRUE,
                                          new.titles = TRUE)

}
\author{
Elena N. Filatova
}
