% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{rate_DF}
\alias{rate_DF}
\title{Rate variables}
\usage{
rate_DF(
  data,
  rate.var,
  weights,
  return = "add",
  as.percent = FALSE,
  percent.var,
  digits = 2
)
}
\arguments{
\item{data}{data frame with rated variables}

\item{rate.var}{character; vector of data frame column names with numeric variables of range (0-1) that should be used for rating}

\item{weights}{numeric; vector of variables' weights (their sum must be 1)}

\item{return}{character; return object; possible values are: \code{"vector"} (return a vector of rate values),
\code{"add"} (add rated values as the latter column in data frame)}

\item{as.percent}{logical; if some rated variables are percentages}

\item{percent.var}{character;  vector of data frame column names with rated variables that are percentages}

\item{digits}{integer; number of decimal places to round the rate value}
}
\value{
Vector or data frame with rate values.
}
\description{
Count data frame's row rate according to several variables
}
\details{
This function counts rate as \code{rate = var1*weight1 + var2*weight2 + var3*weight3 +...} etc.
All variables must be in range (0-1) and sum of weights must be 1. If you use percentages as rating variable, use \code{as.percent = TRUE}.
Those variables would be divided by 100 before rating and then would be multiplicated by 100 after rating.

\code{rate.var} and  \code{percent.var} must be exact column names as in data frame.
}
\examples{
data <- data.frame (N = 1:5, percent = c(12, 15, 18, 20, 94), number = c(0.1, 0.5, 0.6, 0.8 ,0.9))
rate_DF (data = data, rate.var = c("percent", "number"), weights = c(0.4, 0.6), return = "add",
                             as.percent = TRUE, percent.var = "percent")

}
\author{
Elena N. Filatova
}
