% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads.R
\name{get_GA_files}
\alias{get_GA_files}
\title{Read GISAID sequence file}
\usage{
get_GA_files(
  dir.path,
  return = "both",
  seq.return = "data.frame",
  fasta.file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dir.path}{character; directory name and path}

\item{return}{character; type of returned object; possible values are:
\code{"info"} (sequence metadata), \code{"seq"} (nucleotide sequences), \code{"both"} (both of them).}

\item{seq.return}{character; sequence returned object;  possible values are "vector", "data.frame" and "fasta"}

\item{fasta.file}{character; FASTA file name and path, only used if \code{return = "fasta"}}

\item{verbose}{logical; show messages}
}
\value{
List of length two, where first is metadata and second is nucleotide sequence.
If \code{return = "info"} or \code{return = "seq"} only first or second element is returned.
}
\description{
Get metadata and nucleotide sequence from GISAID files
}
\details{
This function works with downloaded from GISAID "Input for the Augur pipeline" archives
(with "metadata.tsv" and "sequences.fasta" files).
Archives must be unzipped before usage.
All extracted from GISAID archive files must be in one directory.

If \code{return = "seq"}, serial numbers are used as sequence identification numbers.

Metadata is transformed into data frame of the same format as \link{get_seq_info} function does.
Sequences are transformed into data type of the same format as \link{get_seq_for_DB} function does.
}
\examples{
\dontrun{
# First download some sequences' archives from GISAID (https://www.gisaid.org/)
# unzip them and put into "gisaidfiles" directory

res <- get_GA_files (dir.path = "gisaidfiles", return = "info")
res <- get_GA_files (dir.path = "gisaidfiles", return = "seq", seq.return = "data.frame")
res <- get_GA_files (dir.path = "gisaidfiles", return ="both", seq.return = "fasta")
}

}
\author{
Elena N. Filatova
}
