% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.r
\name{as.data.frame.disk.frame}
\alias{as.data.frame.disk.frame}
\title{Convert disk.frame to data.frame by collecting all chunks}
\usage{
\method{as.data.frame}{disk.frame}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{a disk.frame}

\item{row.names}{NULL or a character vector giving the row names for the data frame. Missing values are not allowed.}

\item{optional}{logical. If TRUE, setting row names and converting column names (to syntactic names: see make.names) is optional. Note that all of R's base package as.data.frame() methods use optional only for column names treatment, basically with the meaning of data.frame(*, check.names = !optional). See also the make.names argument of the matrix method.}

\item{...}{additional arguments to be passed to or from methods.}
}
\description{
Convert disk.frame to data.frame by collecting all chunks
}
\examples{
cars.df = as.disk.frame(cars)
as.data.frame(cars.df)

# clean up
delete(cars.df)
}
