% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.r
\name{compute.disk.frame}
\alias{compute.disk.frame}
\title{Force computations. The results are stored in a folder.}
\usage{
\method{compute}{disk.frame}(x, name = NULL, outdir = tempfile("tmp_df_", fileext = ".df"), ...)
}
\arguments{
\item{x}{a disk.frame}

\item{name}{If not NULL then used as outdir prefix.}

\item{outdir}{the output directory}

\item{...}{Passed to `write_disk.frame`}
}
\description{
Perform the computation; same as calling cmap without .f and lazy = FALSE
}
\examples{
cars.df = as.disk.frame(cars)
cars.df2 = cars.df \%>\% cmap(~.x)
# the computation is performed and the data is now stored elsewhere
cars.df3 = compute(cars.df2)

# clean up
delete(cars.df)
delete(cars.df3)
}
