% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindlist.disk.frame.r
\name{rbindlist.disk.frame}
\alias{rbindlist.disk.frame}
\title{rbindlist disk.frames together}
\usage{
rbindlist.disk.frame(df_list, outdir = tempfile(fileext = ".df"),
  by_chunk_id = TRUE, parallel = TRUE, compress = 50,
  overwrite = TRUE, .progress = TRUE)
}
\arguments{
\item{df_list}{A list of disk.frames}

\item{outdir}{Output directory of the row-bound disk.frames}

\item{by_chunk_id}{If TRUE then only the chunks with the same chunk IDs will be bound}

\item{parallel}{if TRUE then bind multiple disk.frame simultaneously, Defaults to TRUE}

\item{compress}{0-100, 100 being the highest compression rate.}

\item{overwrite}{overwrite the output directory}

\item{.progress}{A logical, for whether or not to print a progress bar for multiprocess, multisession, and multicore plans. From {furrr}}
}
\description{
rbindlist disk.frames together
}
\examples{
cars.df = as.disk.frame(cars)

# row-bind two disk.frames
cars2.df = rbindlist.disk.frame(list(cars.df, cars.df))

# clean up cars.df
delete(cars.df)
delete(cars2.df)
}
