% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{as.disag_data}
\alias{as.disag_data}
\title{Function to fit the disaggregation model}
\usage{
as.disag_data(
  polygon_shapefile,
  shapefile_names,
  covariate_rasters,
  polygon_data,
  covariate_data,
  aggregation_pixels,
  coordsForFit,
  coordsForPrediction,
  startendindex,
  mesh = NULL
)
}
\arguments{
\item{polygon_shapefile}{sf object containing the response data}

\item{shapefile_names}{List of 2: polygon id variable name and response variable name from x}

\item{covariate_rasters}{SpatRaster of covariates}

\item{polygon_data}{data.frame with two columns: polygon id and response}

\item{covariate_data}{data.frame with cell id, polygon id and covariate columns}

\item{aggregation_pixels}{vector with value of aggregation raster at each pixel}

\item{coordsForFit}{coordinates of the covariate data points within the polygons in x}

\item{coordsForPrediction}{coordinates of the covariate data points in the whole raster extent}

\item{startendindex}{matrix containing the start and end index for each polygon}

\item{mesh}{inla.mesh object to use in the fit}
}
\value{
A list is returned of class \code{disag_data}.
The functions \emph{summary}, \emph{print} and \emph{plot} can be used on \code{disag_data}.
The list  of class \code{disag_data} contains:
 \item{x }{The sf object used as an input.}
 \item{covariate_rasters }{The SpatRaster used as an input.}
 \item{polygon_data }{A data frame with columns of \emph{area_id}, \emph{response} and \emph{N} (sample size: all NAs unless using binomial data). Each row represents a polygon.}
 \item{covariate_data }{A data frame with columns of \emph{area_id}, \emph{cell_id} and one for each covariate in \emph{covariate_rasters}. Each row represents a pixel in a polygon.}
 \item{aggregation_pixels }{An array with the value of the aggregation raster for each pixel in the same order as the rows of \emph{covariate_data}.}
 \item{coordsForFit }{A matrix with two columns of x, y coordinates of pixels within the polygons. Used to make the spatial field.}
 \item{coordsForPrediction }{A matrix with two columns of x, y coordinates of pixels in the whole Raster. Used to make predictions.}
 \item{startendindex }{A matrix with two columns containing the start and end index of the pixels within each polygon.}
 \item{mesh }{A INLA mesh to be used for the spatial field of the disaggregation model.}
}
\description{
Function to fit the disaggregation model
}
