% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet_process_beta_2.R
\name{DirichletProcessBeta2}
\alias{DirichletProcessBeta2}
\title{Dirichlet process mixture of Beta distributions with a Uniform Pareto base measure.}
\usage{
DirichletProcessBeta2(y, maxY, g0Priors = 2, alphaPrior = c(2, 4),
  mhStep = c(1, 1), verbose = TRUE, mhDraws = 250)
}
\arguments{
\item{y}{Data for which to be modelled.}

\item{maxY}{End point of the data}

\item{g0Priors}{Prior parameters of the base measure \eqn{(\gamma}.}

\item{alphaPrior}{Prior parameters for the concentration parameter. See also \code{\link{UpdateAlpha}}.}

\item{mhStep}{Step size for Metropolis Hastings sampling algorithm.}

\item{verbose}{Logical, control the level of on screen output.}

\item{mhDraws}{Number of Metropolis-Hastings samples to perform for each cluster update.}
}
\value{
Dirichlet process object
}
\description{
Create a Dirichlet process object using the mean and scale parameterisation of the Beta distribution bounded on \eqn{(0, maxY)}.
The Pareto distribution is used as a prior on the scale parameter to ensure that the likelihood is 0 at the boundaries.
}
\details{
\eqn{G_0 (\mu , \nu | maxY, \alpha ) = U(\mu | 0, maxY) \mathrm{Pareto} (\nu | x_m, \gamma)}.
}
