% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-package.R
\name{prepare_install}
\alias{prepare_install}
\alias{prepare_install2}
\title{Install Packages at Next Startup}
\usage{
prepare_install(
  packages,
  update_all = FALSE,
  restart = FALSE,
  repos = getOption("repos")
)

prepare_install2(packages, restart = FALSE, repos = getOption("repos"), ...)
}
\arguments{
\item{packages}{characters, vector of package names}

\item{update_all}{whether to update all installed packages before
installation; default is false}

\item{restart}{whether to restart session automatically}

\item{repos}{repositories to search for packages}

\item{...}{internal arguments}
}
\value{
None
}
\description{
Register temporary code that will install packages at
next session. The code will be automatically removed once executed.
}
\details{
\code{prepare_install} is soft-deprecated, use \code{prepare_install2}
instead.

Installing packages in R session could require restarts if
a package to be updated has been loaded. Normally restarting R
fixes the problem. However, under some circumstances, such as with a
startup code in profile, restarting R might still fail the
installation. \code{prepare_install2} starts a new session with clean
environments for installation.
}
