% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-actionbutton-styled.R
\name{actionButtonStyled}
\alias{actionButtonStyled}
\title{Action Button but with customized styles}
\usage{
actionButtonStyled(
  inputId,
  label,
  icon = NULL,
  width = NULL,
  type = "primary",
  btn_type = "button",
  class = "",
  ...
)
}
\arguments{
\item{inputId, label, icon, width, ...}{passed to \code{shiny::actionButton}}

\item{type}{button type, choices are `default`, `primary`, `info`, `success`,
`warning`, and `danger`}

\item{btn_type}{HTML tag type, either \code{"button"} or \code{"a"}}

\item{class}{additional classes to be added to the button}
}
\value{
`HTML` tags
}
\description{
Action Button but with customized styles
}
\examples{

# demo('example-actionButtonStyled', package='dipsaus')

library(shiny)
library(dipsaus)

ui <- fluidPage(
  actionButtonStyled('btn', label = 'Click me', type = 'default'),
  actionButtonStyled('btn2', label = 'Click me2', type = 'primary')
)


server <- function(input, output, session) {
  btn_types = c('default', 'primary', 'info', 'success', 'warning', 'danger')
  observeEvent(input$btn, {
    btype = btn_types[((input$btn-1) \%\% (length(btn_types)-1)) + 1]
    updateActionButtonStyled(session, 'btn2', type = btype)
  })
  observeEvent(input$btn2, {
    updateActionButtonStyled(session, 'btn',
                             disabled = c(FALSE,TRUE)[(input$btn2 \%\% 2) + 1])
  })
}


if( interactive() ){
  shinyApp(ui, server, options = list(launch.browser=TRUE))
}

}
\seealso{
\code{\link[dipsaus]{updateActionButtonStyled}} for how to update the button.
}
