% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{\%?<-\%}
\alias{\%?<-\%}
\title{Assign if not exists, or NULL
Provides a way to assign default values to variables. If the statement
`\code{lhs}` is invalid or \code{NULL}, this function will try to assign
\code{value}, otherwise nothing happens.}
\usage{
lhs \%?<-\% value
}
\arguments{
\item{lhs}{an object to check or assign}

\item{value}{value to be assigned if lhs is NULL}
}
\value{
Assign value on the right-hand side to the left-hand side if
\code{lhs} does not exist or is \code{NULL}
}
\description{
Assign if not exists, or NULL
Provides a way to assign default values to variables. If the statement
`\code{lhs}` is invalid or \code{NULL}, this function will try to assign
\code{value}, otherwise nothing happens.
}
\examples{
# Prepare, remove aaa if exists
if(exists('aaa', envir = globalenv(), inherits = FALSE)){
  rm(aaa, envir = globalenv())
}

# Assign
aaa \%?<-\% 1; print(aaa)

# However, if assigned, nothing happens
aaa = 1;
aaa \%?<-\% 2;
print(aaa)

# in a list
a = list()
a$e \%?<-\% 1; print(a$e)
a$e \%?<-\% 2; print(a$e)

}
