% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{get_contributions}
\alias{get_contributions}
\alias{get_contributions-method}
\alias{get_correlations}
\alias{get_correlations-method}
\alias{get_cos2}
\alias{get_cos2-method}
\alias{get_contributions,MultivariateAnalysis-method}
\alias{get_correlations,PCA-method}
\alias{get_cos2,MultivariateAnalysis-method}
\title{Get Contributions}
\usage{
get_contributions(x, ...)

get_correlations(x, ...)

get_cos2(x, ...)

\S4method{get_contributions}{MultivariateAnalysis}(x, margin = 1)

\S4method{get_correlations}{PCA}(x, sup_name = ".sup")

\S4method{get_cos2}{MultivariateAnalysis}(x, margin = 1, sup_name = ".sup")
}
\arguments{
\item{x}{An object from which to get element(s) (a \code{\linkS4class{CA}} or
\code{\linkS4class{PCA}} object).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{sup_name}{A \code{\link{character}} string specifying the name of the column to
create for supplementary points attribution (see below).}
}
\value{
\itemize{
\item \code{get_contributions()} returns a \code{\link{data.frame}} of contributions to the
definition of the principal dimensions.
\item \code{get_correlations()} returns a \code{\link{data.frame}} of correlations between
variables and dimensions (\code{PCA}). An extra column (named after \code{sup_name})
is added specifying whether an observation is a supplementary point or
not.
\item \code{get_cos2()} returns a \code{\link{data.frame}} of \eqn{cos^2}{cos2} values (i.e.
quality of the representation of the points on the factor map). An extra
column (named after \code{sup_name}) is added specifying whether an observation
is a supplementary point or not.
}
}
\description{
Get Contributions
}
\seealso{
Other mutators: 
\code{\link{dimnames}()},
\code{\link{get_coordinates}()},
\code{\link{get_data}()},
\code{\link{get_distances}()},
\code{\link{get_eigenvalues}()},
\code{\link{loadings}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
