test_that("Correspondence Analysis", {
  cts <- matrix(data = sample(1:10, 100, TRUE), ncol = 5)
  res <- ca(cts)

  expect_null(res[["X"]])
  expect_type(res[["data"]], "integer")
  expect_length(res[["data"]], 100)
  expect_type(res[["rows"]], "list")
  expect_length(res[["rows"]], 5)
  expect_type(res[["columns"]], "list")
  expect_length(res[["columns"]], 5)
  expect_type(res[["eigenvalues"]], "double")
  expect_length(res[["eigenvalues"]], 4)
})
test_that("Principal Components Analysis", {
  cts <- matrix(data = sample(1:10, 100, TRUE), ncol = 5)
  res <- pca(cts)

  expect_null(res[["X"]])
  expect_type(res[["data"]], "list")
  expect_length(res[["data"]], 3)
  expect_type(res[["rows"]], "list")
  expect_length(res[["rows"]], 5)
  expect_type(res[["columns"]], "list")
  expect_length(res[["columns"]], 6)
  expect_type(res[["eigenvalues"]], "double")
  expect_length(res[["eigenvalues"]], 4)
})
