% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{par_frame}
\alias{par_frame}
\title{Get Parent Frame of S4 Call Stack}
\usage{
par_frame()
}
\value{
an environment
}
\description{
Implementation of the \code{function(x=parent.frame()) ...} pattern for the
\code{\link[=diffPrint]{diff*}} methods since the normal pattern does not
work with S4 methods.  Works by looking through the call stack and
identifying what call likely initiated the S4 dispatch.
}
\details{
The function is not exported and intended only for use as the default value
for the \code{frame} argument for the \code{\link[=diffPrint]{diff*}}
methods.

Matching is done purely by looking for the last repeated call followed
by \code{.local(target, current, ...)} that is not a call to \code{eval}.
This pattern seems to match the correct call most of the time.
Since methods can be renamed by the user we make no attempt to verify method
names.  This method could potentially be tricked if you implement custom
\code{\link[=diffPrint]{diff*}} methods that somehow
issue two identical sequential calls before calling \code{callNextMethod}.
Failure in this case means the wrong \code{frame} will be returned.
}

