# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Recherche exhaustive des problemes de differentiation
#' 
#' Fonction exposée permettant de détecter les différenciations territoire/carreau
#' Elle prépare les paramètres et appelle la fonction récursive explorerRcpp
#' 
#' Remarque : Il est inutile d'explorer des tailles d'agrégats supérieures à nbTerritoires/2
#' 
#' @param iTailleCible : entiers indiquant la taille des agrégats à tester
#' @param iSeuil : entier indiquant le seuil en dessous duquel il y a rupture du secret statistique
#' @param vNbObsTerritoire : vecteur d'entiers contenant le nombre d'observations pour chaque territoire
#' @param vNbObsCarreaux : vecteur d'entiers contenant le nombre d'observations pour chaque carreau
#' @param mContiguiteT : matrice d'entiers indiquant la contiguité territoire/territoire - la diagonale est supposée à zéro
#' @param mContiguiteTC : matrice d'entiers indiquant la contiguité territoire/carreau - les territoires sont en ligne et les carreaux en colonne
#'  
#' @return liste de vecteurs dont chaque élément est une différenciation. 
#'          Chaque élément est un vecteur constitué 
#'          - des indices des territoires de l'agrégat 
#'          - du nombre d'observations différenciées à l'intérieur 
#'          - et enfin du nombre d'observations différenciées à l'extérieur
#'  
#' @author Arlindo Dos Santos / PSAR Analyse urbaine
differencierRcpp <- function(iTailleCible, iSeuil, vNbObsTerritoire, vNbObsCarreaux, mContiguiteT, mContiguiteTC) {
    .Call('_diffman_differencierRcpp', PACKAGE = 'diffman', iTailleCible, iSeuil, vNbObsTerritoire, vNbObsCarreaux, mContiguiteT, mContiguiteTC)
}

