/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.internal.RegexCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AsYouTypeFormatter {
    private String currentOutput = "";
    private StringBuilder formattingTemplate = new StringBuilder();
    private String currentFormattingPattern = "";
    private StringBuilder accruedInput = new StringBuilder();
    private StringBuilder accruedInputWithoutFormatting = new StringBuilder();
    private boolean ableToFormat = true;
    private boolean inputHasFormatting = false;
    private boolean isCompleteNumber = false;
    private boolean isExpectingCountryCallingCode = false;
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private String defaultCountry;
    private static final char SEPARATOR_BEFORE_NATIONAL_NUMBER = ' ';
    private static final Phonemetadata.PhoneMetadata EMPTY_METADATA = Phonemetadata.PhoneMetadata.newBuilder().setId("<ignored>").setInternationalPrefix("NA").build();
    private Phonemetadata.PhoneMetadata defaultMetadata;
    private Phonemetadata.PhoneMetadata currentMetadata;
    private static final Pattern ELIGIBLE_FORMAT_PATTERN = Pattern.compile("[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]*(\\$\\d[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]*)+");
    private static final Pattern NATIONAL_PREFIX_SEPARATORS_PATTERN = Pattern.compile("[- ]");
    private static final int MIN_LEADING_DIGITS_LENGTH = 3;
    private static final String DIGIT_PLACEHOLDER = "\u2008";
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\u2008");
    private int lastMatchPosition = 0;
    private int originalPosition = 0;
    private int positionToRemember = 0;
    private StringBuilder prefixBeforeNationalNumber = new StringBuilder();
    private boolean shouldAddSpaceAfterNationalPrefix = false;
    private String extractedNationalPrefix = "";
    private StringBuilder nationalNumber = new StringBuilder();
    private List<Phonemetadata.NumberFormat> possibleFormats = new ArrayList<Phonemetadata.NumberFormat>();
    private RegexCache regexCache = new RegexCache(64);

    AsYouTypeFormatter(String regionCode) {
        this.defaultCountry = regionCode;
        this.defaultMetadata = this.currentMetadata = this.getMetadataForRegion(this.defaultCountry);
    }

    private Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        int countryCallingCode = this.phoneUtil.getCountryCodeForRegion(regionCode);
        String mainCountry = this.phoneUtil.getRegionCodeForCountryCode(countryCallingCode);
        Phonemetadata.PhoneMetadata metadata = this.phoneUtil.getMetadataForRegion(mainCountry);
        if (metadata != null) {
            return metadata;
        }
        return EMPTY_METADATA;
    }

    private boolean maybeCreateNewTemplate() {
        Iterator<Phonemetadata.NumberFormat> it = this.possibleFormats.iterator();
        while (it.hasNext()) {
            Phonemetadata.NumberFormat numberFormat = it.next();
            String pattern = numberFormat.getPattern();
            if (this.currentFormattingPattern.equals(pattern)) {
                return false;
            }
            if (this.createFormattingTemplate(numberFormat)) {
                this.currentFormattingPattern = pattern;
                this.shouldAddSpaceAfterNationalPrefix = NATIONAL_PREFIX_SEPARATORS_PATTERN.matcher(numberFormat.getNationalPrefixFormattingRule()).find();
                this.lastMatchPosition = 0;
                return true;
            }
            it.remove();
        }
        this.ableToFormat = false;
        return false;
    }

    private void getAvailableFormats(String leadingDigits) {
        boolean isInternationalNumber = this.isCompleteNumber && this.extractedNationalPrefix.length() == 0;
        List<Phonemetadata.NumberFormat> formatList = isInternationalNumber && this.currentMetadata.getIntlNumberFormatCount() > 0 ? this.currentMetadata.getIntlNumberFormatList() : this.currentMetadata.getNumberFormatList();
        for (Phonemetadata.NumberFormat format : formatList) {
            if (this.extractedNationalPrefix.length() > 0 && PhoneNumberUtil.formattingRuleHasFirstGroupOnly(format.getNationalPrefixFormattingRule()) && !format.getNationalPrefixOptionalWhenFormatting() && !format.hasDomesticCarrierCodeFormattingRule() || this.extractedNationalPrefix.length() == 0 && !this.isCompleteNumber && !PhoneNumberUtil.formattingRuleHasFirstGroupOnly(format.getNationalPrefixFormattingRule()) && !format.getNationalPrefixOptionalWhenFormatting() || !ELIGIBLE_FORMAT_PATTERN.matcher(format.getFormat()).matches()) continue;
            this.possibleFormats.add(format);
        }
        this.narrowDownPossibleFormats(leadingDigits);
    }

    private void narrowDownPossibleFormats(String leadingDigits) {
        int indexOfLeadingDigitsPattern = leadingDigits.length() - 3;
        Iterator<Phonemetadata.NumberFormat> it = this.possibleFormats.iterator();
        while (it.hasNext()) {
            int lastLeadingDigitsPattern;
            Pattern leadingDigitsPattern;
            Matcher m;
            Phonemetadata.NumberFormat format = it.next();
            if (format.getLeadingDigitsPatternCount() == 0 || (m = (leadingDigitsPattern = this.regexCache.getPatternForRegex(format.getLeadingDigitsPattern(lastLeadingDigitsPattern = Math.min(indexOfLeadingDigitsPattern, format.getLeadingDigitsPatternCount() - 1)))).matcher(leadingDigits)).lookingAt()) continue;
            it.remove();
        }
    }

    private boolean createFormattingTemplate(Phonemetadata.NumberFormat format) {
        String numberPattern = format.getPattern();
        this.formattingTemplate.setLength(0);
        String tempTemplate = this.getFormattingTemplate(numberPattern, format.getFormat());
        if (tempTemplate.length() > 0) {
            this.formattingTemplate.append(tempTemplate);
            return true;
        }
        return false;
    }

    private String getFormattingTemplate(String numberPattern, String numberFormat) {
        String longestPhoneNumber = "999999999999999";
        Matcher m = this.regexCache.getPatternForRegex(numberPattern).matcher(longestPhoneNumber);
        m.find();
        String aPhoneNumber = m.group();
        if (aPhoneNumber.length() < this.nationalNumber.length()) {
            return "";
        }
        String template = aPhoneNumber.replaceAll(numberPattern, numberFormat);
        template = template.replaceAll("9", DIGIT_PLACEHOLDER);
        return template;
    }

    public void clear() {
        this.currentOutput = "";
        this.accruedInput.setLength(0);
        this.accruedInputWithoutFormatting.setLength(0);
        this.formattingTemplate.setLength(0);
        this.lastMatchPosition = 0;
        this.currentFormattingPattern = "";
        this.prefixBeforeNationalNumber.setLength(0);
        this.extractedNationalPrefix = "";
        this.nationalNumber.setLength(0);
        this.ableToFormat = true;
        this.inputHasFormatting = false;
        this.positionToRemember = 0;
        this.originalPosition = 0;
        this.isCompleteNumber = false;
        this.isExpectingCountryCallingCode = false;
        this.possibleFormats.clear();
        this.shouldAddSpaceAfterNationalPrefix = false;
        if (!this.currentMetadata.equals(this.defaultMetadata)) {
            this.currentMetadata = this.getMetadataForRegion(this.defaultCountry);
        }
    }

    public String inputDigit(char nextChar) {
        this.currentOutput = this.inputDigitWithOptionToRememberPosition(nextChar, false);
        return this.currentOutput;
    }

    public String inputDigitAndRememberPosition(char nextChar) {
        this.currentOutput = this.inputDigitWithOptionToRememberPosition(nextChar, true);
        return this.currentOutput;
    }

    private String inputDigitWithOptionToRememberPosition(char nextChar, boolean rememberPosition) {
        this.accruedInput.append(nextChar);
        if (rememberPosition) {
            this.originalPosition = this.accruedInput.length();
        }
        if (!this.isDigitOrLeadingPlusSign(nextChar)) {
            this.ableToFormat = false;
            this.inputHasFormatting = true;
        } else {
            nextChar = this.normalizeAndAccrueDigitsAndPlusSign(nextChar, rememberPosition);
        }
        if (!this.ableToFormat) {
            if (this.inputHasFormatting) {
                return this.accruedInput.toString();
            }
            if (this.attemptToExtractIdd()) {
                if (this.attemptToExtractCountryCallingCode()) {
                    return this.attemptToChoosePatternWithPrefixExtracted();
                }
            } else if (this.ableToExtractLongerNdd()) {
                this.prefixBeforeNationalNumber.append(' ');
                return this.attemptToChoosePatternWithPrefixExtracted();
            }
            return this.accruedInput.toString();
        }
        switch (this.accruedInputWithoutFormatting.length()) {
            case 0: 
            case 1: 
            case 2: {
                return this.accruedInput.toString();
            }
            case 3: {
                if (this.attemptToExtractIdd()) {
                    this.isExpectingCountryCallingCode = true;
                    break;
                }
                this.extractedNationalPrefix = this.removeNationalPrefixFromNationalNumber();
                return this.attemptToChooseFormattingPattern();
            }
        }
        if (this.isExpectingCountryCallingCode) {
            if (this.attemptToExtractCountryCallingCode()) {
                this.isExpectingCountryCallingCode = false;
            }
            return this.prefixBeforeNationalNumber + this.nationalNumber.toString();
        }
        if (this.possibleFormats.size() > 0) {
            String tempNationalNumber = this.inputDigitHelper(nextChar);
            String formattedNumber = this.attemptToFormatAccruedDigits();
            if (formattedNumber.length() > 0) {
                return formattedNumber;
            }
            this.narrowDownPossibleFormats(this.nationalNumber.toString());
            if (this.maybeCreateNewTemplate()) {
                return this.inputAccruedNationalNumber();
            }
            return this.ableToFormat ? this.appendNationalNumber(tempNationalNumber) : this.accruedInput.toString();
        }
        return this.attemptToChooseFormattingPattern();
    }

    private String attemptToChoosePatternWithPrefixExtracted() {
        this.ableToFormat = true;
        this.isExpectingCountryCallingCode = false;
        this.possibleFormats.clear();
        this.lastMatchPosition = 0;
        this.formattingTemplate.setLength(0);
        this.currentFormattingPattern = "";
        return this.attemptToChooseFormattingPattern();
    }

    String getExtractedNationalPrefix() {
        return this.extractedNationalPrefix;
    }

    private boolean ableToExtractLongerNdd() {
        if (this.extractedNationalPrefix.length() > 0) {
            this.nationalNumber.insert(0, this.extractedNationalPrefix);
            int indexOfPreviousNdd = this.prefixBeforeNationalNumber.lastIndexOf(this.extractedNationalPrefix);
            this.prefixBeforeNationalNumber.setLength(indexOfPreviousNdd);
        }
        return !this.extractedNationalPrefix.equals(this.removeNationalPrefixFromNationalNumber());
    }

    private boolean isDigitOrLeadingPlusSign(char nextChar) {
        return Character.isDigit(nextChar) || this.accruedInput.length() == 1 && PhoneNumberUtil.PLUS_CHARS_PATTERN.matcher(Character.toString(nextChar)).matches();
    }

    String attemptToFormatAccruedDigits() {
        for (Phonemetadata.NumberFormat numberFormat : this.possibleFormats) {
            Matcher m = this.regexCache.getPatternForRegex(numberFormat.getPattern()).matcher(this.nationalNumber);
            if (!m.matches()) continue;
            this.shouldAddSpaceAfterNationalPrefix = NATIONAL_PREFIX_SEPARATORS_PATTERN.matcher(numberFormat.getNationalPrefixFormattingRule()).find();
            String formattedNumber = m.replaceAll(numberFormat.getFormat());
            String fullOutput = this.appendNationalNumber(formattedNumber);
            String formattedNumberDigitsOnly = PhoneNumberUtil.normalizeDiallableCharsOnly(fullOutput);
            if (!formattedNumberDigitsOnly.contentEquals(this.accruedInputWithoutFormatting)) continue;
            return fullOutput;
        }
        return "";
    }

    public int getRememberedPosition() {
        int currentOutputIndex;
        if (!this.ableToFormat) {
            return this.originalPosition;
        }
        int accruedInputIndex = 0;
        for (currentOutputIndex = 0; accruedInputIndex < this.positionToRemember && currentOutputIndex < this.currentOutput.length(); ++currentOutputIndex) {
            if (this.accruedInputWithoutFormatting.charAt(accruedInputIndex) != this.currentOutput.charAt(currentOutputIndex)) continue;
            ++accruedInputIndex;
        }
        return currentOutputIndex;
    }

    private String appendNationalNumber(String nationalNumber) {
        int prefixBeforeNationalNumberLength = this.prefixBeforeNationalNumber.length();
        if (this.shouldAddSpaceAfterNationalPrefix && prefixBeforeNationalNumberLength > 0 && this.prefixBeforeNationalNumber.charAt(prefixBeforeNationalNumberLength - 1) != ' ') {
            return new String(this.prefixBeforeNationalNumber) + ' ' + nationalNumber;
        }
        return this.prefixBeforeNationalNumber + nationalNumber;
    }

    private String attemptToChooseFormattingPattern() {
        if (this.nationalNumber.length() >= 3) {
            this.getAvailableFormats(this.nationalNumber.toString());
            String formattedNumber = this.attemptToFormatAccruedDigits();
            if (formattedNumber.length() > 0) {
                return formattedNumber;
            }
            return this.maybeCreateNewTemplate() ? this.inputAccruedNationalNumber() : this.accruedInput.toString();
        }
        return this.appendNationalNumber(this.nationalNumber.toString());
    }

    private String inputAccruedNationalNumber() {
        int lengthOfNationalNumber = this.nationalNumber.length();
        if (lengthOfNationalNumber > 0) {
            String tempNationalNumber = "";
            for (int i = 0; i < lengthOfNationalNumber; ++i) {
                tempNationalNumber = this.inputDigitHelper(this.nationalNumber.charAt(i));
            }
            return this.ableToFormat ? this.appendNationalNumber(tempNationalNumber) : this.accruedInput.toString();
        }
        return this.prefixBeforeNationalNumber.toString();
    }

    private boolean isNanpaNumberWithNationalPrefix() {
        return this.currentMetadata.getCountryCode() == 1 && this.nationalNumber.charAt(0) == '1' && this.nationalNumber.charAt(1) != '0' && this.nationalNumber.charAt(1) != '1';
    }

    private String removeNationalPrefixFromNationalNumber() {
        Pattern nationalPrefixForParsing;
        Matcher m;
        int startOfNationalNumber = 0;
        if (this.isNanpaNumberWithNationalPrefix()) {
            startOfNationalNumber = 1;
            this.prefixBeforeNationalNumber.append('1').append(' ');
            this.isCompleteNumber = true;
        } else if (this.currentMetadata.hasNationalPrefixForParsing() && (m = (nationalPrefixForParsing = this.regexCache.getPatternForRegex(this.currentMetadata.getNationalPrefixForParsing())).matcher(this.nationalNumber)).lookingAt() && m.end() > 0) {
            this.isCompleteNumber = true;
            startOfNationalNumber = m.end();
            this.prefixBeforeNationalNumber.append(this.nationalNumber.substring(0, startOfNationalNumber));
        }
        String nationalPrefix = this.nationalNumber.substring(0, startOfNationalNumber);
        this.nationalNumber.delete(0, startOfNationalNumber);
        return nationalPrefix;
    }

    private boolean attemptToExtractIdd() {
        Pattern internationalPrefix = this.regexCache.getPatternForRegex("\\+|" + this.currentMetadata.getInternationalPrefix());
        Matcher iddMatcher = internationalPrefix.matcher(this.accruedInputWithoutFormatting);
        if (iddMatcher.lookingAt()) {
            this.isCompleteNumber = true;
            int startOfCountryCallingCode = iddMatcher.end();
            this.nationalNumber.setLength(0);
            this.nationalNumber.append(this.accruedInputWithoutFormatting.substring(startOfCountryCallingCode));
            this.prefixBeforeNationalNumber.setLength(0);
            this.prefixBeforeNationalNumber.append(this.accruedInputWithoutFormatting.substring(0, startOfCountryCallingCode));
            if (this.accruedInputWithoutFormatting.charAt(0) != '+') {
                this.prefixBeforeNationalNumber.append(' ');
            }
            return true;
        }
        return false;
    }

    private boolean attemptToExtractCountryCallingCode() {
        if (this.nationalNumber.length() == 0) {
            return false;
        }
        StringBuilder numberWithoutCountryCallingCode = new StringBuilder();
        int countryCode = this.phoneUtil.extractCountryCode(this.nationalNumber, numberWithoutCountryCallingCode);
        if (countryCode == 0) {
            return false;
        }
        this.nationalNumber.setLength(0);
        this.nationalNumber.append((CharSequence)numberWithoutCountryCallingCode);
        String newRegionCode = this.phoneUtil.getRegionCodeForCountryCode(countryCode);
        if ("001".equals(newRegionCode)) {
            this.currentMetadata = this.phoneUtil.getMetadataForNonGeographicalRegion(countryCode);
        } else if (!newRegionCode.equals(this.defaultCountry)) {
            this.currentMetadata = this.getMetadataForRegion(newRegionCode);
        }
        String countryCodeString = Integer.toString(countryCode);
        this.prefixBeforeNationalNumber.append(countryCodeString).append(' ');
        this.extractedNationalPrefix = "";
        return true;
    }

    private char normalizeAndAccrueDigitsAndPlusSign(char nextChar, boolean rememberPosition) {
        char normalizedChar;
        if (nextChar == '+') {
            normalizedChar = nextChar;
            this.accruedInputWithoutFormatting.append(nextChar);
        } else {
            int radix = 10;
            normalizedChar = Character.forDigit(Character.digit(nextChar, radix), radix);
            this.accruedInputWithoutFormatting.append(normalizedChar);
            this.nationalNumber.append(normalizedChar);
        }
        if (rememberPosition) {
            this.positionToRemember = this.accruedInputWithoutFormatting.length();
        }
        return normalizedChar;
    }

    private String inputDigitHelper(char nextChar) {
        Matcher digitMatcher = DIGIT_PATTERN.matcher(this.formattingTemplate);
        if (digitMatcher.find(this.lastMatchPosition)) {
            String tempTemplate = digitMatcher.replaceFirst(Character.toString(nextChar));
            this.formattingTemplate.replace(0, tempTemplate.length(), tempTemplate);
            this.lastMatchPosition = digitMatcher.start();
            return this.formattingTemplate.substring(0, this.lastMatchPosition + 1);
        }
        if (this.possibleFormats.size() == 1) {
            this.ableToFormat = false;
        }
        this.currentFormattingPattern = "";
        return this.accruedInput.toString();
    }
}

