% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.R
\name{get_timezone}
\alias{get_timezone}
\title{Phone number time zone}
\usage{
get_timezone(x, strict = FALSE)
}
\arguments{
\item{x}{A \link{phone} vector.}

\item{strict}{Should invalid phone numbers be removed? If \code{TRUE}, invalid
phone numbers are replaced with \code{NA}.}
}
\value{
A character vector of time zones to which each phone number belongs,
separated by \verb{;}, or the default unknown time zone \code{"Etc/Unknown"} if no
other time zone was found.
}
\description{
Retrieve a list of \href{http://www.unicode.org/cldr/charts/latest/supplemental/zone_tzid.html}{CLDR time zones}
to which a phone number belongs.
}
\details{
This function assumes the phone number is geo-localizable. Fixed-line and
mobile numbers are considered possible candidates for geo-localization.
}
\section{libphonenumber reference}{


\code{get_timezone()}:
\code{PhoneNumberToTimeZonesMapper.getTimeZonesForGeographicalNumber()}.
}

\examples{
x <- phone(c(0, 0123, "0412 345 678", "61412987654", "03 9123 4567", "+12015550123"), "AU")
get_timezone(x)
get_timezone(x, strict = TRUE)

# Return a list
strsplit(get_timezone(x), ";")
}
