% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region.R
\name{dialr-region}
\alias{dialr-region}
\alias{get_region}
\alias{get_supported_regions}
\alias{get_region_for_calling_code}
\alias{get_regions_for_calling_code}
\title{Phone number region}
\usage{
get_region(x)

get_supported_regions()

get_region_for_calling_code(x)

get_regions_for_calling_code(x)
}
\arguments{
\item{x}{A \link{phone} vector, or a vector of calling codes.}
}
\value{
A character vector of country codes.

\code{get_regions_for_calling_code()} returns a list of character vectors for
each provided calling code.
}
\description{
In libphonenumber a phone number region is represented by a 2 digit ISO
country code. \code{get_region(x)} returns the 2-digit \href{https://en.wikipedia.org/wiki/ISO_3166-1}{ISO country code} for each element of a \link{phone}
vector.

Use \code{get_supported_regions()} to see a full list of supported regions.

Region can also be retrieved from an international calling code.
\code{get_region_for_calling_code(x)} returns the main region for each provided
calling code. Since multiple regions can share a single calling code,
\code{get_regions_for_calling_code(x)} returns a list of character vectors of
regions for each.
}
\section{libphonenumber reference}{


\code{get_region()}: \code{PhoneNumberUtil.getRegionCodeForNumber()}

\code{get_supported_regions()}: \code{PhoneNumberUtil.getSupportedRegions()}

\code{get_region_for_calling_code()}:
\code{PhoneNumberUtil.getRegionCodeForCountryCode()}

\code{get_regions_for_calling_code()}:
\code{PhoneNumberUtil.getRegionCodesForCountryCode()}
}

\examples{
  # Get regions for a phone vector
  x <- phone(c(0, 0123, "0412 345 678", "61412987654", "03 9123 4567", "+12015550123"), "AU")
  get_region(x)

  # All supported region codes
  get_supported_regions()
  
  # Primary region for a calling code
  get_region_for_calling_code(c(1, 61, 84))
  
  # All regions for a calling code
  get_regions_for_calling_code(c(1, 61, 84))
  
}
\seealso{
Other phone functions: 
\code{\link{dialr-example}},
\code{\link{dialr-match}},
\code{\link{dialr-phone}},
\code{\link{dialr-type}},
\code{\link{dialr-valid}},
\code{\link{dialr}}
}
\concept{phone functions}
