% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwrapper.R
\name{dgQ2DI_to_PROJTRI}
\alias{dgQ2DI_to_PROJTRI}
\title{Convert from Q2DI to PROJTRI}
\usage{
dgQ2DI_to_PROJTRI(dggs, in_quad, in_i, in_j)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{in_quad}{Vector of quad numbers}

\item{in_i}{Vector of quadrant i values}

\item{in_j}{Vector of quadrant j values}
}
\value{
Returns a dggs object which can be passed to other dggridR
            functions
}
\description{
Uses a discrete global grid system to convert between Q2DI
            and PROJTRI (see vignette for details)
}
\examples{
\dontrun{
library(dggridR)
dggs <- dgconstruct(res=20)

dgQ2DI_to_PROJTRI(dggs, in_quad, in_i, in_j)
}

}
