% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{touch_rules}
\alias{touch_rules}
\title{Add or modify scoring rules}
\usage{
touch_rules(db, rules)
}
\arguments{
\item{db}{a connection to a dexter project database}

\item{rules}{A data frame with columns \code{item_id}, \code{response}, and \code{item_score}.
The order is not important but spelling is. Any other columns will be ignored. See details}
}
\value{
If the scoring rules pass a sanity check, a small summary of changes is printed and nothing is returned
Otherwise this function returns a data frame listing the problems found, with 4 columns:
item_id: id of the problematic item
less_than_two_scores: if TRUE, the item has only one distinct score
duplicated_responses: if TRUE, the item contains two or more identical response categories
min_score_not_zero: if TRUE, the minimum score of the item was not 0
}
\description{
Having to alter or add a scoring rule is occasionally necessary, e.g. in case of a key error. 
This function offers the possibility to do so and also allows you to add new items to your project
}
\details{
The rules should contain all rules that you want to change or add. This means that in case of a key error
in a single multiple choice question, you typically have to change two rules.
}
\examples{
\donttest{
# given that in your dexter project there is an mc item with id 'itm_01', 
# which currently has key 'A' but you want to change it to 'C'.

new_rules = data.frame(item_id='itm_01', response=c('A','C'), item_score=c(0,1))
touch_rules(db, new_rules)
}

}
