% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.r
\name{install_deps}
\alias{install_deps}
\title{Install package dependencies if needed.}
\usage{
install_deps(pkg = ".", dependencies = NA, threads = getOption("Ncpus",
  1), repos = getOption("repos"), type = getOption("pkgType"), ...,
  upgrade = TRUE, quiet = FALSE, force_deps = FALSE)
}
\arguments{
\item{pkg}{package description, can be path or package name.  See
\code{\link{as.package}} for more information}

\item{dependencies}{\code{logical} indicating to also install uninstalled
packages which this \code{pkg} depends on/links to/suggests. See
argument \code{dependencies} of \code{\link{install.packages}}.}

\item{threads}{number of concurrent threads to use for installing
dependencies.
It defaults to the option \code{"Ncpus"} or \code{1} if unset.}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.  If "both", will switch
automatically to "binary" to avoid interactive prompts during package
installation.}

\item{...}{additional arguments passed to \code{\link{install.packages}}.}

\item{upgrade}{If \code{TRUE}, also upgrade any of out date dependencies.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{force_deps}{whether to force installation of dependencies even if their
SHA1 reference hasn't changed from the currently installed version.}
}
\description{
Install package dependencies if needed.
}
\examples{
\dontrun{install_deps(".")}
}

