% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lamb_92}
\alias{lamb_92}
\title{Lamb equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\usage{
lamb_92
}
\description{
Lamb, R. J., Gerber, G. H., & Atkinson, G. F. (1984). Comparison of developmental rate curves
applied to egg hatching data of Entomoscelis americana Brown (Coleoptera: Chrysomelidae).
Environmental entomology, 13(3), 868-872.

Lamb, RJ. (1992) Developmental rate of Acyrthosiphon pisum (Homoptera: Aphididae) at low
temperatures: implications for estimating rate parameters for insects.
Environmental Entomology 21(1): 10-19.
}
\details{
Equation:
\deqn{rT = Rm * e^{-\frac{1}{2} * (\frac{T - Tmax}{To})^{2}}}{%
      rT = Rm * exp(-1/2 * ((T - Tmax)/To)^2)}
and
\deqn{rT = Rm * e^{-\frac{1}{2} * (\frac{T - Tmax}{T1})^{2}}}{%
      rT = Rm * exp(-1/2 * ((T - Tmax)/T1)^2)}

where rT is the development rate, T the temperature, Rm the maximum
development rate, Tmax the optimum temperature, and To and T1 the shape parameter giving
the spread of the curve.
}
\references{
\doi{10.1093/ee/21.1.10}
}
\keyword{datasets}
