% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_example.R
\docType{data}
\name{exTropicalMoth}
\alias{exTropicalMoth}
\title{Tropical moth development rate at constant temperatures.}
\format{A list of two elements with a list of three elements.
\describe{
  \item{raw}{The raw data extracted from Crespo-Perez et al. 2011.
    \describe{
      \item{eggs}{raw temperatures and development rates}
      \item{larva}{raw temperatures and development rates}
      \item{pupa}{raw temperatures and development rates}
    }
  }
  \item{model}{The nls object returned by the devRateModel function.
    \describe{
      \item{eggs}{nls object}
      \item{larva}{nls object}
      \item{pupa}{nls object}
    }
  }
}}
\usage{
exTropicalMoth
}
\description{
This is a sample dataset to be used in the package examples. In this example,
we used data from Crespo-Perez et al. (2011) on the potato tuber moth Tecia
solanivora (Lepidoptera: Gelechiidae), a major crop pest in the central Andes
of Ecuador. We used Web Plot Digitizer (Rohatgi 2015) to extract the data on
development rate as a function of temperature.

Crespo-Perez, V., Rebaudo, F., Silvain, J.-F. & Dangles, O. (2011).
Modeling invasive species spread in complex landscapes: the case of potato moth
in Ecuador. Landscape ecology, 26, 1447-1461.

Rohatgi, A. (2015). WebPlotDigitalizer: HTML5 based online tool
to extract numerical data from plot images.
}
\keyword{datasets}
