% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lactin2_95}
\alias{lactin2_95}
\title{Lactin et al. equation 2 of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}}
\source{
\url{http://dx.doi.org/10.1093/ee/24.1.68}
}
\usage{
lactin2_95
}
\description{
Lactin, Derek J, NJ Holliday, DL Johnson, y R Craigen (995) Improved rate model of
temperature-dependent development by arthropods. Environmental Entomology 24(1): 68-75.
}
\details{
Equation:
\deqn{rT = e^{aa * T} - e^{aa * Tmax - \frac{Tmax - T}{deltaT}} + bb}{%
      rT = exp(aa * T) - exp(aa * Tmax - (Tmax - T)/deltaT) + bb}

where rT is the development rate, T the temperature, and aa, bb, Tmax,
and deltaT fitted parameters.
}
\keyword{datasets}
