% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myrs.R
\name{rtoboxes}
\alias{rtoboxes}
\title{Randomly place balls in boxes.}
\usage{
rtoboxes(n, boxes, weights = NULL, capacities = NULL)
}
\arguments{
\item{n}{A natural number. The number of balls to put into the boxes.}

\item{boxes}{A natural number. The number of boxes.}

\item{weights}{A non-negative numeric vector. The relative probabilities of
putting a ball in each box. Default is each box is equally likely.}

\item{capacities}{A vector of natural numbers. The capacity of each box.
Default is each box has infinite capacity.}
}
\value{
A vector of natural numbers with the same length as \code{boxes}. The
number of balls placed in each box.
}
\description{
Given a number of boxes, randomly distribute \emph{n} balls into these boxes.
}
\examples{
rtoboxes(30, 7)
rtoboxes(30, 7, capacities = c(rep(1, 3), rep(7, 4)))
rtoboxes(30, 7, capacities = c(rep(1, 3), rep(70, 4)),
         weights = c(rep(0.1, 6), 1))

}
\seealso{
rfromboxes
}
