% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_stats.R
\name{mean_frames}
\alias{mean_frames}
\alias{sum_frames}
\title{Get the sums/means of frames in a 3-dimensional array.}
\usage{
mean_frames(arr3d, na_rm = FALSE)

sum_frames(arr3d, na_rm = FALSE)
}
\arguments{
\item{arr3d}{A 3-dimensional numeric array.}

\item{na_rm}{Do you want \code{NA} values to be excluded from calculations?}
}
\value{
A numeric vector.
}
\description{
Frame \code{i} of a 3-dimensional array \code{arr3d} is defined as \code{arr3d[, , i]}.
}
\examples{
a <- array(seq_len(2 ^ 3), dim = rep(2, 3))
sum_frames(a)
mean_frames(a)

}
