% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar_stats.R
\name{brightness_pillars}
\alias{brightness_pillars}
\title{Get the brightness of pillars of a 3d array.}
\usage{
brightness_pillars(arr3d, parallel = FALSE)
}
\arguments{
\item{arr3d}{A 3-dimensional array.}

\item{parallel}{Do you want to parallelize the computation across multiple
cores? If so, set this to the number of cores that you would like to use,
or set it to \code{TRUE} to use all available cores.}
}
\value{
A matrix where element \code{i,j} is equal to \code{var(mat3d[i, j, ]) / mean(mat3d[i, j, ])}.
}
\description{
For a 3-dimensional array \code{mat3d}, pillar \code{ij} is defined as \code{mat3d[i, j, ]}.
This function computes the brightness of each pillar. Brightness is \code{variance / mean}.
}
\examples{
aaa <- array(1:16, dim = c(2, 2, 4))
brightness_pillars(aaa)

}
