% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-summary-stats.R
\name{ds_summary_stats}
\alias{ds_summary_stats}
\alias{summary_stats}
\title{Descriptive Statistics}
\usage{
ds_summary_stats(data, variable)
}
\arguments{
\item{data}{a \code{data.frame} or a \code{tibble}}

\item{variable}{numeric; column in \code{data}}
}
\value{
\code{ds_summary_stats} returns an object of class
\code{"ds_summary_stats"}. An object of class \code{"ds_summary_stats"}
is a list containing the following components

\item{obs}{number of observations}
\item{missing}{number of missing observations}
\item{avg}{mean}
\item{tavg}{5 percent trimmed mean}
\item{stdev}{standard deviation}
\item{variance}{variance}
\item{skew}{skewness}
\item{kurtosis}{kurtosis}
\item{uss}{uncorrected sum of squares}
\item{css}{corrected sum of squares}
\item{cvar}{coefficient of variation}
\item{sem}{standard error of mean}
\item{median}{median}
\item{mode}{mode}
\item{range}{range}
\item{min}{minimum value}
\item{iqrange}{inter quartile range}
\item{per99}{99th percentile}
\item{per95}{95th percentile}
\item{per90}{90th percentile}
\item{per75}{75th percentile}
\item{per25}{25th percentile}
\item{per10}{10th percentile}
\item{per5}{5th percentile}
\item{per1}{1st percentile}
\item{lowobs}{five lowest observations}
\item{highobs}{five highest observations}
\item{lowobsi}{index of five lowest observations}
\item{highobsi}{index of five highest observations}
}
\description{
\code{ds_summary_stats} returns a whole range of descriptive
statistics for continuous data.
}
\section{Deprecated Function}{

\code{summary_stats()} has been deprecated. Instead use
\code{ds_summary_stats()}.
}

\examples{
ds_summary_stats(mtcarz, mpg)
}
\seealso{
\code{\link[base]{summary}} \code{\link{ds_freq_cont}}
\code{\link{ds_freq_table}} \code{\link{ds_cross_table}}
}
