% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-freq-table.R
\name{ds_freq_table}
\alias{ds_freq_table}
\alias{freq_table}
\alias{barplot.ds_freq_table}
\title{Frequency Table: Categorical Data}
\usage{
ds_freq_table(data)

\method{barplot}{ds_freq_table}(height, ...)
}
\arguments{
\item{data}{numeric or factor vector}

\item{height}{an object of class \code{ds_freq_table}}

\item{...}{further arguments to be passed to or from methods}
}
\value{
\code{ds_freq_table} returns an object of class \code{"ds_freq_table"}.
An object of class \code{"ds_freq_table"} is a list containing the
following components

\item{ftable}{frequency table}
\item{varname}{name of the data}
}
\description{
\code{ds_freq_table} creates frequency table for factor data and
returns the frequency, cumulative frequency, frequency percent and cumulative
frequency percent. \code{barplot.ds_freq_table} creates bar plot for the
frequency table created using \code{ds_freq_table}
}
\section{Deprecated Function}{

\code{freq_table()} has been deprecated. Instead use \code{ds_freq_table()}.
}

\examples{
# frequency table
mt <- mtcars
mt$cyl <- as.factor(mt$cyl)
ds_freq_table(mt$cyl)

# barplot
mt <- mtcars
mt$cyl <- as.factor(mt$cyl)
k <- ds_freq_table(mt$cyl)
barplot(k)
}
\seealso{
\code{link{ds_freq_cont}} \code{link{ds_cross_table}}
}
