% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct_edges.R
\name{distinct_edges}
\alias{distinct_edges}
\title{Finds distinct edges in one tree compared to another}
\source{
A \link{dendrogram} implementation for \link[distory]{distinct.edges} from the {distory} package
}
\usage{
distinct_edges(dend, dend2, ...)
}
\arguments{
\item{dend}{a dendrogram to find unique edges in}

\item{dend2}{a dendrogram to compare with}

\item{...}{Ignored.}
}
\value{
A numeric vector of edge ids for the first tree (dend) that are not present in the second tree (dend2).
}
\description{
Finds the edges present in the first tree but not in the second
}
\examples{

x <- 1:5 \%>\% dist \%>\% hclust \%>\% as.dendrogram
y <- set(x, "labels", 5:1)
distinct_edges(x, y)
distinct_edges(y, x)
dend_diff(x, y)
# tanglegram(x, y)

}
\seealso{
\link{distinct_edges}, \link{highlight_distinct_edges},
\link{dist.dendlist}, \link{tanglegram}
\link[distory]{distinct.edges}
}

