% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.dendlist}
\alias{plot.dendlist}
\title{A plot S3 method for dendlist}
\usage{
\method{plot}{dendlist}(x, which = c(1L, 2L), ...)
}
\arguments{
\item{x}{a dendlist}

\item{which}{an integer vector of length 2, indicating
which of the trees in the dendlist object should be plotted}

\item{...}{parameters to be passed to the plot/tanglegram function}
}
\value{
A dendlist object
}
\description{
If the dendlist if of length 1 - then use a normal plotting method.
If it is of length 2 or more, use a tangelgram.
}
\examples{
\dontrun{

dend <- iris[1:20, -5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend2 <- iris[1:20, -5] \%>\% dist \%>\% hclust(method = "single") \%>\% as.dendrogram

x <- dendlist(dend, dend2)
plot(x)

}
}

