% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_vdem.R
\name{prep_vdem}
\alias{prep_vdem}
\title{Prepare V-Dem Data}
\usage{
prep_vdem(
  vdem,
  years = NULL,
  metrics = NULL,
  drop_no_cow = FALSE,
  cow_index = FALSE,
  drop_pal = FALSE,
  srb_kos = FALSE,
  srb_mon = FALSE,
  micro = TRUE,
  iso3 = FALSE
)
}
\arguments{
\item{vdem}{A \code{data.frame} or \code{data.table} of raw vdem observations.}

\item{years}{A numeric vector of length 2 with start and end years to subset
by.}

\item{metrics}{Character vector of vdem metrics of interest to subset
against. These will be combined with country-year id variables by default.}

\item{drop_no_cow}{Logical to drop observations without Correlates of War
country codes.}

\item{cow_index}{Logical to index vdem against valid Correlates of War
country-years.}

\item{drop_pal}{Logical to remove all Palestine related observations.}

\item{srb_kos}{Logical to average metrics Serbia/Yugoslavia with Kosovo for
all years < 2008.}

\item{srb_mon}{Logical to calculate values for the State Union of Serbia and
Montenegro (2003-2006) using the average of Serbia's and Montenegro's
scores. To include Kosovo, specify \code{srb_kos = TRUE}.}

\item{micro}{Logical to keep (TRUE) or drop (FALSE) microstates.}

\item{iso3}{Logical to generate ISO3C country codes.}
}
\value{
A \code{data.frame} of post-processed vdem data.
}
\description{
Given a raw data.frame of vdem data, enact further
automated pre-processing.
}
\examples{
\donttest{
vdem<-demcon::get_vdem(write_out = FALSE)

vdem<-prep_vdem(vdem, years = c(2010, 2020), cow_index = TRUE, micro = FALSE)}

}
