% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_geo.R
\docType{data}
\name{coord_geo}
\alias{coord_geo}
\alias{CoordGeo}
\title{Transformed coordinate system with geological timescale}
\usage{
coord_geo(
  pos = "bottom",
  dat = "periods",
  xlim = NULL,
  ylim = NULL,
  xtrans = identity_trans(),
  ytrans = identity_trans(),
  clip = "on",
  expand = FALSE,
  fill = NULL,
  alpha = 1,
  height = unit(2, "line"),
  bord = c("left", "right", "top", "bottom"),
  lwd = 0.25,
  color = "black",
  lab = TRUE,
  lab_color = NULL,
  rot = 0,
  family = "sans",
  fontface = "plain",
  size = 5,
  skip = c("Quaternary", "Holocene", "Late Pleistocene"),
  abbrv = TRUE,
  neg = FALSE,
  center_end_labels = FALSE,
  dat_is_discrete = FALSE,
  fittext_args = list()
)
}
\arguments{
\item{pos}{Which side to add the scale to (left, right, top, or bottom).
First letter may also be used.}

\item{dat}{Either A) a string indicating a built-in dataframe with interval
data from the ICS ("periods", "epochs", "stages", "eons", or "eras"),
B) a string indicating a timescale from macrostrat (see list here:
\url{https://macrostrat.org/api/defs/timescales?all}), or C) a custom
data.frame of time interval boundaries (see Details).}

\item{xlim, ylim}{Limits for the x and y axes.}

\item{xtrans, ytrans}{Transformers for the x and y axes. For more information
see \code{\link[ggplot2:coord_trans]{ggplot2::coord_trans()}}.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}

\item{expand}{If \code{FALSE}, the default, limits are taken exactly from the data
or \code{xlim}/\code{ylim}. If \code{TRUE}, adds a small expansion factor to the limits to
ensure that data and axes don't overlap.}

\item{fill}{The fill color of the boxes. The default is to use the \code{color}
column included in \code{dat}. If a custom dataset is provided with \code{dat}
without a \code{color} column and without fill, a greyscale will be used.
Custom fill colors can be provided with this option (overriding the \code{color}
column) and will be recycled if/as necessary.}

\item{alpha}{The transparency of the fill colors.}

\item{height}{The height (or width if \code{pos} is \code{left} or \code{right}) of the
scale.}

\item{bord}{A vector specifying on which sides of the scale to add borders
(same options as \code{pos}).}

\item{lwd}{Line width.}

\item{color}{The outline color of the interval boxes.}

\item{lab}{Whether to include labels.}

\item{lab_color}{The color of the labels. The default is to use the
\code{lab_color} column included in \code{dat}. If a custom dataset is provided with
\code{dat} without a \code{lab_color} column and without fill, all labels will be
black. Custom label colors can be provided with this option (overriding the
\code{lab_color} column) and will be recycled if/as necessary.}

\item{rot}{The amount of counter-clockwise rotation to add to the labels
(in degrees).}

\item{family}{The font family to use for the labels. There are only three
fonts that are guaranteed to work everywhere: “sans” (the default),
“serif”, or “mono”.}

\item{fontface}{The font face to use for the labels. The standard options are
"plain" (default), "bold", "italic", and "bold.italic".}

\item{size}{Label size. Either a number as you would specify in
\code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} or \code{"auto"} to use \code{\link[ggfittext:geom_fit_text]{ggfittext::geom_fit_text()}}.}

\item{skip}{A vector of interval names indicating which intervals should not
be labeled. If \code{abbrv} is \code{TRUE}, this can also include interval
abbreviations.}

\item{abbrv}{If including labels, whether to use abbreviations instead of
full interval names.}

\item{neg}{Set this to true if your x-axis is using negative values.}

\item{center_end_labels}{Should labels be centered within the visible range
of intervals at the ends of the axis?}

\item{dat_is_discrete}{Are the ages in \code{dat} already converted for a discrete
scale?}

\item{fittext_args}{A list of named arguments to provide to
\code{\link[ggfittext:geom_fit_text]{ggfittext::geom_fit_text()}}. Only used if \code{size} is set to \code{"auto"}.}
}
\description{
\code{coord_geo} behaves similarly to \code{\link[ggplot2:coord_trans]{ggplot2::coord_trans()}} in that it occurs
after statistical transformation and will affect the visual appearance of
geoms. The main difference is that it also adds a geological timescale to the
specified side(s) of the plot.
}
\details{
Transforming the side with the scale is not currently implemented.
If a custom data.frame is provided (with \code{dat}), it should consist of at
least 3 columns of data. See \code{data(periods)} for an example.
\itemize{
\item The \code{name} column lists the names of each time interval. These will
be used as labels if no abbreviations are provided.
\item The \code{max_age} column lists the oldest boundary of each time interval.
\item The \code{min_age} column lists the youngest boundary of each time
interval.
\item The \code{abbr} column is optional and lists abbreviations that may be
used as labels.
\item The \code{color} column is also optional and lists a
\link[ggplot2:aes_colour_fill_alpha]{color} for the background for each time interval.
\item The \code{lab_color} column is also optional and lists a
\link[ggplot2:aes_colour_fill_alpha]{color} for the label for each time interval.
}

If the axis of the time scale is discrete, \code{max_age} and \code{min_age} will
automatically be converted to the discrete scale. In this case, the
categories of the discrete axis should match the values in the \code{name} column.
If the ages within \code{dat} are already discretized, you can set
\code{dat_is_discrete} to \code{TRUE} to prevent this automatic conversion. This can be
useful for adding a time scale where categories and time intervals are not
1:1.

\code{pos} may also be a \code{list} of sides (including duplicates) if multiple time
scales should be added to the plot. In this case, \code{dat}, \code{fill}, \code{alpha},
\code{height}, \code{bord}, \code{lwd}, \code{color}, \code{lab}, \code{lab_color}, \code{rot}, \code{family},
\code{fontface}, \code{size}, \code{skip}, \code{abbrv}, \code{neg}, \code{center_end_labels}, and
\code{dat_is_discrete} can also be \code{list}s. If these \code{list}s are not as long as
\code{pos}, the elements will be recycled.
If individual values (or vectors) are used for these parameters, they will be
applied to all time scales (and recycled as necessary).
}
\examples{
library(ggplot2)
# single scale on bottom
ggplot() +
  geom_point(aes(y = runif(1000, 0, 8), x = runif(1000, 0, 1000))) +
  scale_x_reverse() +
  coord_geo(xlim = c(1000, 0), ylim = c(0, 8)) +
  theme_classic()

# stack multiple scales
ggplot() +
  geom_point(aes(y = runif(1000, 0, 8), x = runif(1000, 0, 100))) +
  scale_x_reverse() +
  coord_geo(
    xlim = c(100, 0), ylim = c(0, 8), pos = as.list(rep("bottom", 3)),
    dat = list("stages", "epochs", "periods"),
    height = list(unit(4, "lines"), unit(4, "lines"), unit(2, "line")),
    rot = list(90, 90, 0), size = list(2.5, 2.5, 5), abbrv = FALSE
  ) +
  theme_classic()
}
\keyword{datasets}
