% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggarrange2.R
\name{ggarrange2}
\alias{ggarrange2}
\title{ggarrange2}
\usage{
ggarrange2(
  ...,
  plots = list(...),
  layout = NULL,
  nrow = NULL,
  ncol = NULL,
  widths = NULL,
  heights = NULL,
  byrow = TRUE,
  top = NULL,
  bottom = NULL,
  left = NULL,
  right = NULL,
  padding = unit(0.5, "line"),
  margin = unit(0.5, "line"),
  clip = "on",
  draw = TRUE,
  newpage = TRUE,
  debug = FALSE,
  labels = NULL,
  label.args = list(gp = gpar(font = 4, cex = 1.2))
)
}
\arguments{
\item{...}{ggplot, grobified ggplot (gtable), or geo_scale objects}

\item{plots}{list of ggplot, gtable, or geo_scale objects}

\item{layout}{a matrix of integers specifying where each plot should go, like \code{mat} in \code{\link[graphics]{layout}}; \code{NA} or a value less than 0 or greater than the number of plots indicates a blank plot; overrides nrow/ncol/byrow}

\item{nrow}{number of rows}

\item{ncol}{number of columns}

\item{widths}{list of requested widths}

\item{heights}{list of requested heights}

\item{byrow}{logical, fill by rows}

\item{top}{optional string, or grob}

\item{bottom}{optional string, or grob}

\item{left}{optional string, or grob}

\item{right}{optional string, or grob}

\item{padding}{unit of length one, margin around annotations}

\item{margin}{vector of units of length 4: top, right, bottom, left (as in \code{\link[gtable]{gtable_add_padding}})}

\item{clip}{argument of gtable}

\item{draw}{logical: draw or return a grob}

\item{newpage}{logical: draw on a new page}

\item{debug}{logical, show layout with thin lines}

\item{labels}{character labels used for annotation of subfigures (should be in the same order as \code{plots})}

\item{label.args}{label list of parameters for the formatting of labels}
}
\value{
gtable of aligned plots
}
\description{
Arrange multiple ggplot, grobified ggplot, or geo_scale objects on a page, aligning the plot panels, axes, and axis titles.
}
\examples{
library(ggplot2)
p1 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point()
p2 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() + facet_wrap( ~ cyl, ncol=2, scales = 'free') +
  guides(colour='none') +
  theme()
ggarrange2(p1, p2, widths = c(2,1), labels = c('a', 'b'))

p3 <- ggplot() +
  geom_point(aes(y = runif(1000, 0, 8), x = runif(1000, 0, 1000))) +
 scale_x_reverse() +
 coord_geo(xlim = c(1000, 0), ylim = c(0,8)) +
 theme_classic()
ggarrange2(ggarrange2(p1, p2, widths = c(2,1), draw = FALSE), p3, nrow = 2)
}
