% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF_block.R
\name{RBF_block}
\alias{RBF_block}
\title{Radial Basis Function Warpings}
\usage{
RBF_block(res = 1L, lims = c(-0.5, 0.5), dtype = "float32")
}
\arguments{
\item{res}{the resolution}

\item{lims}{the limits of one side of the square 2D domain on which to set up the RBFs}

\item{dtype}{data type}
}
\value{
\code{RBF_block} returns a list containing a list for each RBF in the block with the following components:
\describe{
 \item{"f"}{An encapsulated function that takes an input and evaluates the RBF over some input using \code{TensorFlow}}
 \item{"fR"}{Same as \code{f} but uses \code{R}}
 \item{"fMC"}{Same as \code{f} but does it in parallel for several inputs index by the first dimension of the tensor}
 \item{"r"}{The number of basis functions (one for each layer)}
 \item{"trans"}{The transformation applied to the weights before estimation}
 \item{"fix_weights"}{Flag indicating whether the weights are fixed or not (FALSE for RBFs)}
 \item{"name"}{Name of layer}
}
}
\description{
Sets up a composition of radial basis functions (RBFs) for used in a deep compositional spatial model. The function
sets up RBFs on a prescribed domain on a grid at a certain resolution.
It returns a list containing all the functions in the single-resolution RBF unit. See Value for more details.
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
layer <- RBF_block(res = 1L)
 }
}
}
