% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{orthog_control}
\alias{orthog_control}
\title{Options for orthogonalization}
\usage{
orthog_control(
  split_fun = split_model,
  orthog_type = c("tf", "manual"),
  orthogonalize = options()$orthogonalize,
  identify_intercept = options()$identify_intercept,
  deep_top = NULL
)
}
\arguments{
\item{split_fun}{a function separating the deep neural network in two parts
so that the orthogonalization can be applied to the first part before
applying the second network part; per default, the function \code{split_model} is
used which assumes a dense layer as penultimate layer and separates the network
into a first part without this last layer and a second part only consisting of a
single dense layer that is fed into the output layer}

\item{orthog_type}{one of two options; If \code{"manual"}, 
the QR decomposition is calculated before model fitting, 
otherwise (\code{"tf"}) a QR is calculated in each batch iteration via TF.
The first only works well for larger batch sizes or ideally batch_size == NROW(y).}

\item{orthogonalize}{logical; if set to \code{TRUE}, automatic orthogonalization is activated}

\item{identify_intercept}{whether to orthogonalize the deep network w.r.t. the intercept
to make the intercept identifiable}

\item{deep_top}{function; optional function to put on top of the deep network instead
of splitting the function using \code{split_fun}}
}
\value{
Returns a list with options
}
\description{
Options for orthogonalization
}
