% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_mle_change_point}
\alias{plot_mle_change_point}
\title{Plot MLE Change Point}
\arguments{
\item{plot_data}{A data frame containing 'tau' and 'value' columns.}

\item{best_tau}{The best tau value for the change point.}

\item{best_value}{The maximum MLE value.}
}
\value{
A ggplot object.
}
\description{
This function creates a plot of MLE change points.
}
\examples{
# Example usage
plot_data <- data.frame(tau = 1:100, value = rnorm(100))
best_tau <- 50
best_value <- max(plot_data$value)
plot_mle_change_point(plot_data, best_tau, best_value)
}
