% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_layer}
\alias{add_layer}
\title{Add any kind of layer to the deckgl widget}
\usage{
add_layer(deckgl, class_name, id, data, properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{class_name}{name of the js layer class, e. g. \code{ScatterplotLayer}}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\value{
deckgl widget
}
\description{
Generic function to add any kind of layer to the deckgl widget.
Usually you will not use this one but any of the \code{add_*_layer} functions instead.
}
